<?php 
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/includeBase.php";
    include "../gUtil/GestoreTabella.php";
    include "../classi/Tabella.php";
    include "include/controlloLogin.php";
    
    // solo i super admin possono vedere gli utenti
    if($_SESSION["geecomAdmin_ruolo"]!="super admin") {
        header("Location: {$percorsoBase}index.php");
    }
    
    $elementiPerPagina = isset($_GET["elementiPerPagina"]) ? filter_input(INPUT_GET,"elementiPerPagina",FILTER_SANITIZE_NUMBER_INT) : 25;
    $tipoUtente        = isset($_GET["tipoUtente"]) ? filter_input(INPUT_GET,"tipoUtente",FILTER_SANITIZE_ADD_SLASHES) : "";
    $ruolo             = (isset($_GET["tipoUtente"]) && $_GET["tipoUtente"]!="") ? filter_input(INPUT_GET,"tipoUtente",FILTER_SANITIZE_ADD_SLASHES) : ["super admin","amministratore","autore"];
    $cerca             = isset($_GET["cerca"]) ? filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_STRING) : "";
    
    if($cerca!="" && strpos($cerca," ")>0) {
        // se è stata immessa più di una stringa nel parametro cerca si sta facendo una ricerca per nome e cognome, in tal caso
        // l'array non deve contenere nome e cognome perché andranno inseriti nella condizione principale
        $parametriRicerca = array("ruolo"=>$ruolo,"email"=>$cerca,"etichetta"=>$cerca);
    }
    else if($cerca!="") {
        $parametriRicerca = array("nome"=>$cerca,"cognome"=>$cerca,"email"=>$cerca,"etichetta"=>$cerca);
    }
    else {
        $parametriRicerca = array("ruolo"=>$ruolo);
    }
    $parametri = array("tabella"=>"geec_utenti", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
        
    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"gestioneUtenti.php");
    
    // se cerca contiene più di una stringa, l'utente probabilmente sta facendo una ricerca per nome e cognome, quindi aggiunge una condizione principale
    if(strpos($cerca," ")>0) {
        $arrCerca = explode(" ",$cerca);
        $ultimoElemento = count($arrCerca) -1;
        $ricerca->setCondizionePrincipale("(nome LIKE '{$arrCerca[0]}%' AND cognome LIKE '%{$arrCerca[$ultimoElemento]}') AND");
    }
    else if($cerca!="") {// se la stringa di ricerca è composta da una sola parola, il parametro nella condizione principale diventa ruolo 
        if(is_array($ruolo)) {
            $ricerca->setCondizionePrincipale("(ruolo LIKE 'super admin' OR ruolo LIKE 'amministratore' OR ruolo LIKE 'autore') AND");
        }
        else {
            $ricerca->setCondizionePrincipale("(ruolo LIKE '$ruolo') AND");
        }
    }
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Amministrazione di Geecom CMS - gestione utenti</title>

        <?php
            include "include/cssBaseAreaAmministrativa.php";
        ?>
    </head>

    <body>

        <header>
            <?php  
                include "include/barraSuperiore.php";

                include "include/header.php";

                include "include/barraMenu.php";
            ?>
        </header>

        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">
                <div id="contenutoPrincipale" class="row">
                    <?php
                        if(isset($_GET["status"])) {
                            if($_GET["status"]==1) {
                                    echo"<p class=\"alert alert-success\">Utente creato</p>";
                            }
                            else if($_GET["status"]==2) {
                                    echo"<p class=\"alert alert-success\">Utente modificato</p>";
                            }
                            else if($_GET["status"]==4) {
                                    echo"<p class=\"alert alert-success\">Stato dell'amministratore modificato</p>";
                            }
                            else if($_GET["status"]==400) {
                                    echo"<p class=\"alert alert-danger\">Indirizzo email già esistente</p>";
                            }
                            else { //status = 5
                                    echo"<p class=\"alert alert-success\">Utente eliminato</p>";
                            }
                        }
                    ?>
                    <div class="col py-4">
                        <div class="card mb-4 box-shadow-lite">
                            <div class="card-header">
                                <span class="card-title mr-2"> Elenco utenti</span>
                                <a href="creaUtente.php" class="btn btn-sm btn-primary" >
                                    Crea nuovo<i class="fas fa-plus ml-2"></i>
                                </a>
                            </div>
                            <div class="card-body">
                                <div class="d-flex justify-content-between mb-3">
                                    <?php
                                        $ricerca->stampaSelectNumeroElementi($cerca,["tipoUtente"=>$tipoUtente]);
                                        $ricerca->stampaFormRicerca($cerca,["tipoUtente"=>$tipoUtente]);
                                    ?>
                                </div>
                                <div class="table-responsive table-sm">

                                    <?php
                                        if(isset($_GET["pag"])) {
                                            $ris = $ricerca->eseguiRicerca($_GET["pag"],"OR");
                                        }
                                        else {
                                            $ris = $ricerca->eseguiRicerca(1,"OR");
                                        }

                                        $colonne = array("ID","Nome","Email","Ruolo","Etichetta","Stato","");
                                        $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
                                        $tabella->setTipo("normale");
                                        while($utente = $ris->fetch_assoc()) {
                                            $nomeCognomeEscape = filter_var($utente["nome"]." ".$utente["cognome"],FILTER_SANITIZE_ADD_SLASHES);
                                            if($utente["stato"]=="non attivato") {
                                                $azioni = array("attiva"=>"attivaUtente({$utente["id"]})","modifica"=>"creaUtente.php?id={$utente["id"]}","elimina"=>"eliminaUtente({$utente["id"]},'$nomeCognomeEscape')");
                                            }
                                            else {
                                                $azioni = array("sospendi"=>"sospendiUtente({$utente["id"]})","modifica"=>"creaUtente.php?id={$utente["id"]}","elimina"=>"eliminaUtente({$utente["id"]},'$nomeCognomeEscape')");
                                            }
                                            $tabella->aggiungiNuovaRiga(array($utente["id"],"<a href=\"creaUtente.php?id={$utente["id"]}\"><b>".$utente["nome"]." ".$utente["cognome"]."</b></a>",$utente["email"],$utente["ruolo"],$utente["etichetta"],$utente["stato"]),$azioni);
                                        }
                                        $tabella->stampa("rigaUtente",0);
                                        $ricerca->stampaPaginazione(true,"gestioneUtenti.php");
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </main>

        <div class="modal fade" id="modalEliminaUtente" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Eliminare l'utente?</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="d-flex flex-row justify-content-center">
                            <img id="immagineComponenteDaEliminare" class="thumb d-none d-lg-block" src="">
                            <div class="align-self-center text-center">
                                <span class="align-self-center text-primary"><em id="nomeElementoDaEliminare"></em></span>
                            </div>
                        </div>
                        <input type="text" class="d-none" id="elementoDaEliminare">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneUtente()"><i class="fas fa-check"></i> Elimina</button>
                    </div>
                </div>
            </div>
        </div>

        <?php 
            include "include/footer.php";

            include "include/modal/modalMenuComponenti.php";

            include "include/modal/cambiaPassword.php";

            include "include/modal/operazioneCompletata.php";

            include "include/jsBaseAreaAmministrativa.php";
        ?>

        <script type="text/javascript">

                function eliminaUtente(id,nomeElemento) {
                    $('#elementoDaEliminare').val(id);
                    $('#nomeElementoDaEliminare').text(nomeElemento);
                    $('#modalEliminaUtente').modal('show');
                }

                function sospendiUtente(id) {
                    $.ajax({
                        type:"POST",
                        url:"../controller/controllerUtenti.php",
                        data:{
                            operazione:"aggiornaStatoUtente",
                            stato:'non attivato',
                            idUtente:id
                        },
                        success:function(result) {
                            if(result=="ok") {
                                location.reload();
                            }
                            else {
                                alert(result);
                            }
                        },
                        error: function() {
                            alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                        }
                    });
                }

                function attivaUtente(id) {
                    $.ajax({
                        type:"POST",
                        url:"../controller/controllerUtenti.php",
                        data:{
                            operazione:"aggiornaStatoUtente",
                            stato:'attivato',
                            idUtente:id
                        },
                        success:function(result) {
                            if(result=="ok") {
                                location.reload();
                            }
                            else {
                                alert(result);
                            }
                        },
                        error: function() {
                            alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                        }
                    });
                }

                function eseguiEliminazioneUtente() {
                    var id = $('#elementoDaEliminare').val();
                    $.ajax({
                        type:"POST",
                        url:"../controller/controllerUtenti.php",
                        data:{
                            operazione:"eliminaUtente",
                            idUtente:id
                        },
                        success:function(result) {
                            if(result=="ok") {
                                document.getElementById("rigaUtente"+id).className = "d-none";
                                $('#modalEliminaUtente').modal('hide');
                            }
                            else {
                                alert(result);
                            }
                        },
                        error: function() {
                            alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                        }
                    });
                }
        </script>
    </body>
</html>
